-- Made by Inn0centJok3r

local M = {}

local doorFL = nil
local doorFR = nil
local doorRL = nil
local doorRR = nil
local hood = nil
local trunk = nil
local doorsOpen = 0
local doorStateChanged = 0
local doorMissing = false
local cabinFilterCoef = 1
local cabinFilterChanged = false
local windowDamaged = false

local windowFRBreakGroup
local windowFLBreakGroup
local windowRRBreakGroup
local windowRLBreakGroup
local windowRBreakGroup 
local sunroofBreakGroup 

local windowBroken = false
local playerSeated = false
local playerSeatedCache = false
local playerSeatedChanged = false
local timerBecauseGameIsRart = 0

-- This code controls the cabin filter depending on whether the doors are opened or glass is broken
local function init(jbeamData)
	
	if electrics.values["isSimpleTrafficCar"] then
		M.updateGFX = nil
		return
	end

	--Get deformGroup name for window damage
	windowFRBreakGroup = jbeamData.windowFRBreakGroup or "doorglass_FR_break"
	windowFLBreakGroup = jbeamData.windowFLBreakGroup or "doorglass_FL_break"
	
	windowRRBreakGroup = jbeamData.windowRRBreakGroup or "doorglass_RR_break"
	windowRLBreakGroup = jbeamData.windowRLBreakGroup or "doorglass_RL_break"
	
	windowRBreakGroup = jbeamData.windowRBreakGroup or "windowglass_R_break"
	sunroofBreakGroup = jbeamData.sunroofBreakGroup or "sunroof"

	playerSeated = false
	playerSeatedCache = false
	playerSeatedChanged = false
	doorFL = nil
	doorFR = nil
	doorRL = nil
	doorRR = nil
	hood = nil
	trunk = nil
	
	if v.data.sounds then
		cabinFilterCoef = v.data.sounds.cabinFilterCoef == nil and 1 or v.data.sounds.cabinFilterCoef
		--print(cabinFilterCoef)
	end
end

local function reset()
	windowBroken = false
	windowDamaged = false
	doorsOpen = 0
	doorStateChanged = 0
	playerSeated = false
	playerSeatedCache = false
	playerSeatedChanged = false
	timerBecauseGameIsRart = 0
	
	if cabinFilterChanged then
		obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", cabinFilterCoef))
		cabinFilterChanged = false
	end
end

local function updateGFX(dt)
	
	playerSeated = playerInfo.anyPlayerSeated
	
	if playerSeated ~= playerSeatedCache or timerBecauseGameIsRart > 0 then
		
		if timerBecauseGameIsRart < 0.1 then
			timerBecauseGameIsRart = timerBecauseGameIsRart + dt
		else
			playerSeatedChanged = true
			timerBecauseGameIsRart = 0
		end
	end
	--Door open detection logic as well as domelight and cabin filter logic
	--set to 1 when doesnt exist
	
	--Check if door glass is broken
	--windowBroken is there to prevent the filter command from being spammed
	if windowDamaged and not windowBroken and playerInfo.anyPlayerSeated or playerSeatedChanged and windowDamaged and playerInfo.anyPlayerSeated then
		windowBroken = true
		cabinFilterChanged = true
		obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 0))
	end
	

	if electrics.values["doorFLCoupler_notAttached"] then
		doorFL = electrics.values["doorFLCoupler_notAttached"]
	else
		doorMissing = true
	end
	if electrics.values["doorFRCoupler_notAttached"] then
		doorFR = electrics.values["doorFRCoupler_notAttached"]
	else
		doorMissing = true
	end
	if electrics.values["doorRLCoupler_notAttached"] then
		doorRL = electrics.values["doorFLCoupler_notAttached"]
	else
		doorMissing = true
	end
	if electrics.values["doorRRCoupler_notAttached"] then
		doorRR = electrics.values["doorFRCoupler_notAttached"]
	else
		doorMissing = true
	end
	if electrics.values["trunkCoupler_notAttached"] then
		trunk = electrics.values["trunkCoupler_notAttached"]
	else
		trunk = 1
	end
	if electrics.values["hoodLatchCoupler_notAttached"] then
		hood = electrics.values["hoodLatchCoupler_notAttached"]
	else
		hood = 1
	end

	if doorFR == 1 or doorFL == 1 or doorRR == 1 or doorRL == 1 then
		doorsOpen = 1
		if doorStateChanged ~= doorsOpen or playerSeatedChanged then
			doorStateChanged = doorsOpen
			if electrics.values["ignitionLevel"] > 0 and not doorMissing then electrics.values["domelight"] = 1 end --only change it when ignition is on and no door is missing (otherwise kinda annoying)
			
			if playerInfo.anyPlayerSeated and not windowBroken or playerSeatedChanged then
				cabinFilterChanged = true
				obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 0))
			end
		end
	else
		doorsOpen = 0
		if doorStateChanged ~= doorsOpen or playerSeatedChanged and not windowBroken then
			doorStateChanged = doorsOpen
			electrics.values["domelight"] = 0
			if playerInfo.anyPlayerSeated and not windowBroken or playerSeatedChanged then
				cabinFilterChanged = false
				obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", cabinFilterCoef))
			end
		end
	end

	if doorsOpen == 1 or trunk == 1 or hood == 1 then
		if electrics.values["ignitionLevel"] > 0 then electrics.values["doorsOpen"] = 1 end 
	else
		electrics.values["doorsOpen"] = 0
	end

	if playerSeatedChanged then
		playerSeatedCache = playerSeated
		playerSeatedChanged = false
	end
end

local function beamBroken(id, energy)
    -- Grab the beam data from v.data
    local beam = v.data.beams[id]

    -- Skip if the beam doesn't have a breakGroup
    if not beam or not beam.breakGroup then return end

	if beam.breakGroup == windowFRBreakGroup or beam.breakGroup == windowFLBreakGroup or beam.breakGroup == windowRLBreakGroup or beam.breakGroup == windowRRBreakGroup or beam.breakGroup == windowRBreakGroup or beam.breakGroup == sunroofBreakGroup then
		windowDamaged = true
	end
end

-- public interface
M.init = init
M.reset = reset
M.beamBroken = beamBroken
M.updateGFX = updateGFX

return M